import Link from 'next/link';
import { allPosts } from 'contentlayer/generated';

export const generateStaticParams = () => {
  const tags = new Set(allPosts.flatMap(p => p.tags ?? []));
  return Array.from(tags).map((t) => ({ tag: t }));
};

export default function TagPage({ params }: { params: { tag: string } }) {
  const list = allPosts.filter(p => (p.tags ?? []).includes(params.tag));
  return (
    <div>
      <h1>태그: {params.tag}</h1>
      <ul>
        {list.map(p => (
          <li key={p.slug}>
            <Link href={`/posts/${p.slug}/`}>{p.title}</Link>
          </li>
        ))}
      </ul>
    </div>
  );
}